:: Create new working folder. Cleandiff contains all new files, temp will be deleted.

mkdir cleandiff
mkdir cleandiff\temp

:: Call the ancient flatex. It does its job perfectly, but for some reason it does not create a new file as it is supposed to do, but instead the new file is called <filename>.flt So we just rename it to clean-comments.tex and move it to a new folder.

C:\flatex.exe master.tex
rename master.flt clean-comments.tex
move clean-comments.tex cleandiff\clean-comments.tex

cd cleandiff

:: We add and commit this file which is then the HEAD Revision.

svn add clean-comments.tex
svn commit -m "" clean-comments.tex

:: Remove comments and \todo{} remarks. On its own the script does the same as flatex, but it does not work well with my documents (tables and the bibliography get messed up). So we just call it, if necessary, after flatex.

perl C:\ltxclean.pl clean-comments.tex > clean-nocomments.tex

:: Put each sentence into a new line. Useful if using svn diff as it makes it easier to track changes. Should be called upon clean-comments.tex as it is useful to keep tack on your comments and todos as well.

perl C:\fmtlatex.pl clean-comments.tex > clean-linebreak.tex

:: Latexdiff shows differences in a PDF. It is often easier to track changes in a nicely compiled document rather than in the source. When using SVN we need to use latexdiff on a flattened document as latexdiff cannot run on a checked-in master-project.

:: Compare HEAD revision with the PREVIOUS revision. First checkout, the run latexdiff. You can specify the revisions you want to compare, e.g. '-r 28' uses the 28th revision.

svn cat -r PREV clean-comments.tex >  temp\PREV.tex
svn cat -r HEAD clean-comments.tex > temp\HEAD.tex

latexdiff -t UNDERLINE temp\PREV.tex temp\HEAD.tex > rev_head_prev.tex

:: Compile the document. It is necessary to run pdflatex 3 times in that order to get the bibliography and cross references right. nonstopmode is used to ignore errors.

pdflatex rev_head_prev.tex -interaction=nonstopmode
bibtex rev_head_prev.tex
pdflatex rev_head_prev.tex -interaction=nonstopmode
pdflatex rev_head_prev.tex -interaction=nonstopmode

:: We delete some files that are not required to track changes. The last command deletes empty 0 byte files that are sometimes generated.

del *.lof
del *.lot
del *.toc
del *.log
del *.dvi
del *.aux
del *.bbl
del *.blg
del *.brf
del *.out
rmdir /Q /S temp
for /r %%F in (*) do if %%~zF==0 del "%%F"

:: Finally we add and commit the remaining files

svn add *
svn commit -m ""
cd..
svn commit cleandiff